/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.IModProvider;

public final class ModJarMetadata
implements JarMetadata {
    private IModFile modFile;
    private ModuleDescriptor descriptor;

    @Deprecated(forRemoval=true, since="1.18")
    static Optional<IModFile> buildFile(IModLocator locator, Predicate<SecureJar> jarTest, BiPredicate<String, String> filter, Path ... files) {
        return ModJarMetadata.buildFile((SecureJar j) -> new ModFile((SecureJar)j, (IModProvider)locator, ModFileParser::modsTomlParser), jarTest, filter, files);
    }

    @Deprecated(forRemoval=true, since="1.18")
    static IModFile buildFile(IModLocator locator, Path ... files) {
        return ModJarMetadata.buildFile(locator, (SecureJar j) -> true, null, files).orElseThrow(() -> new IllegalArgumentException("Failed to find valid JAR file"));
    }

    @Deprecated(forRemoval=true, since="1.18")
    static Optional<IModFile> buildFile(Function<SecureJar, IModFile> mfConstructor, Predicate<SecureJar> jarTest, BiPredicate<String, String> filter, Path ... files) {
        ModJarMetadata mjm = new ModJarMetadata();
        SecureJar sj = SecureJar.from(() -> ModFile.DEFAULTMANIFEST, j -> mjm, filter, (Path[])files);
        if (jarTest.test(sj)) {
            IModFile mf = mfConstructor.apply(sj);
            mjm.setModFile(mf);
            return Optional.of(mf);
        }
        return Optional.empty();
    }

    ModJarMetadata() {
    }

    public void setModFile(IModFile file) {
        this.modFile = file;
    }

    public String name() {
        return this.modFile.getModFileInfo().moduleName();
    }

    public String version() {
        return this.modFile.getModFileInfo().versionString();
    }

    public ModuleDescriptor descriptor() {
        if (this.descriptor != null) {
            return this.descriptor;
        }
        ModuleDescriptor.Builder bld = ModuleDescriptor.newAutomaticModule(this.name()).version(this.version()).packages(this.modFile.getSecureJar().getPackages());
        this.modFile.getSecureJar().getProviders().stream().filter(p -> !p.providers().isEmpty()).forEach(p -> bld.provides(p.serviceName(), p.providers()));
        this.modFile.getModFileInfo().usesServices().forEach(bld::uses);
        this.descriptor = bld.build();
        return this.descriptor;
    }

    public IModFile modFile() {
        return this.modFile;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ModJarMetadata that = (ModJarMetadata)obj;
        return Objects.equals(this.modFile, that.modFile);
    }

    public int hashCode() {
        return Objects.hash(this.modFile);
    }

    public String toString() {
        return "ModJarMetadata[modFile=" + this.modFile + "]";
    }
}

